/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyPolyline16
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPolys;
    private int[] numberOfPoints;
    private Point[][] points;

    PolyPolyline16() {
        super(90, 1);
    }

    public PolyPolyline16(Rectangle bounds, int numberOfPolys, int[] numberOfPoints, Point[][] points) {
        this();
        this.bounds = bounds;
        this.numberOfPolys = numberOfPolys;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int i;
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        for (i = 0; i < np; ++i) {
            pc[i] = emf.readDWORD();
            points[i] = new Point[pc[i]];
        }
        for (i = 0; i < np; ++i) {
            points[i] = emf.readPOINTS(pc[i]);
        }
        PolyPolyline16 tag = new PolyPolyline16(bounds, np, pc, points);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        int i;
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.numberOfPolys);
        int c = 0;
        for (i = 0; i < this.numberOfPolys; ++i) {
            c += this.numberOfPoints[i];
        }
        emf.writeDWORD(c);
        for (i = 0; i < this.numberOfPolys; ++i) {
            emf.writeDWORD(this.numberOfPoints[i]);
        }
        for (i = 0; i < this.numberOfPolys; ++i) {
            emf.writePOINTS(this.numberOfPoints[i], this.points[i]);
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #polys: " + this.numberOfPolys;
    }
}

