/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.freehep.graphicsio.emf.Arc;
import org.freehep.graphicsio.emf.ArcTo;
import org.freehep.graphicsio.emf.BeginPath;
import org.freehep.graphicsio.emf.Chord;
import org.freehep.graphicsio.emf.CloseFigure;
import org.freehep.graphicsio.emf.CreatePen;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.Ellipse;
import org.freehep.graphicsio.emf.LineTo;
import org.freehep.graphicsio.emf.LogPen;
import org.freehep.graphicsio.emf.MoveToEx;
import org.freehep.graphicsio.emf.Pie;
import org.freehep.util.io.Tag;

public class EMFDisplay
extends JPanel {
    private EMFInputStream is;
    private Point currentPosition;
    private AffineTransform at;

    public EMFDisplay() {
        this.setBackground(Color.white);
    }

    public EMFDisplay(EMFInputStream is) {
        this.is = is;
        try {
            EMFHeader header = is.readHeader();
            this.setSize(header.getBounds().width, header.getBounds().height);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setBackground(Color.white);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.at == null) {
            this.at = new AffineTransform();
            this.at.setToIdentity();
        }
        Graphics2D g2 = (Graphics2D)g;
        try {
            EMFHeader header = this.is.readHeader();
            AffineTransform toCenterAt = new AffineTransform();
            toCenterAt.concatenate(this.at);
            Rectangle bounds = header.getBounds();
            System.out.println("bounds " + bounds);
            toCenterAt.translate(50.0, 50.0);
            g2.transform(this.at);
            g2.drawLine(-100, 0, 100, 0);
            g2.drawLine(0, -100, 0, 100);
            this.at = toCenterAt;
            g2.draw(bounds);
            System.out.println("device " + header.getDevice());
            Tag tag = this.is.readTag();
            while (tag != null) {
                System.out.println(tag);
                this.map(tag, g2);
                tag = this.is.readTag();
            }
        }
        catch (IOException ioexp) {
            ioexp.printStackTrace();
        }
    }

    private void map(Tag tag, Graphics2D g2) {
        if (tag instanceof Arc) {
            Arc arc = (Arc)tag;
            double nx0 = arc.getStart().x / arc.getBounds().width;
            double nx1 = arc.getEnd().x / arc.getBounds().width;
            double alpha0 = Math.acos(nx0);
            double alpha1 = Math.acos(nx1);
            Arc2D.Double arc2d = new Arc2D.Double(arc.getStart().x, arc.getStart().y, arc.getBounds().width, arc.getBounds().height, alpha0, alpha1 - alpha0, 0);
            g2.draw(arc2d);
        } else if (tag instanceof ArcTo) {
            ArcTo arc = (ArcTo)tag;
            double nx0 = arc.getStart().x / arc.getBounds().width;
            double nx1 = arc.getEnd().x / arc.getBounds().width;
            double alpha0 = Math.acos(nx0);
            double alpha1 = Math.acos(nx1);
            this.currentPosition = arc.getEnd();
            Arc2D.Double arc2d = new Arc2D.Double(arc.getStart().x, arc.getStart().y, arc.getBounds().width, arc.getBounds().height, alpha0, alpha1 - alpha0, 0);
            g2.draw(arc2d);
        } else if (!(tag instanceof BeginPath)) {
            if (tag instanceof Chord) {
                Chord arc = (Chord)tag;
                double nx0 = arc.getStart().x / arc.getBounds().width;
                double nx1 = arc.getEnd().x / arc.getBounds().width;
                double alpha0 = Math.acos(nx0);
                double alpha1 = Math.acos(nx1);
                this.currentPosition = arc.getEnd();
                Arc2D.Double arc2d = new Arc2D.Double(arc.getStart().x, arc.getStart().y, arc.getBounds().width, arc.getBounds().height, alpha0, alpha1 - alpha0, 1);
                g2.draw(arc2d);
            } else if (!(tag instanceof CloseFigure)) {
                if (tag instanceof CreatePen) {
                    CreatePen cpen = (CreatePen)tag;
                    LogPen lpen = cpen.getPen();
                    float[] dash = null;
                    if (lpen.getPenStyle() == 1) {
                        dash = new float[]{5.0f, 5.0f};
                    } else if (lpen.getPenStyle() == 3) {
                        dash = new float[]{5.0f, 2.0f, 1.0f, 2.0f};
                    } else if (lpen.getPenStyle() == 4) {
                        dash = new float[]{5.0f, 2.0f, 1.0f, 2.0f, 1.0f, 2.0f};
                    } else if (lpen.getPenStyle() == 2) {
                        dash = new float[]{1.0f, 2.0f};
                    } else if (lpen.getPenStyle() == 0) {
                        dash = new float[]{1.0f};
                    } else {
                        System.out.println("got unsupported pen style " + lpen.getPenStyle());
                    }
                    BasicStroke bs = new BasicStroke(lpen.getWidth(), 2, 2, 1.0f, dash, 0.0f);
                    g2.setStroke(bs);
                } else if (tag instanceof Ellipse) {
                    Ellipse el = (Ellipse)tag;
                    Ellipse2D.Double el2 = new Ellipse2D.Double(el.getBounds().getX(), el.getBounds().getY(), el.getBounds().getWidth(), el.getBounds().getHeight());
                    g2.draw(el2);
                } else if (tag instanceof LineTo) {
                    LineTo lineTo = (LineTo)tag;
                    Line2D.Double l2 = new Line2D.Double(this.currentPosition, lineTo.getPoint());
                    g2.draw(l2);
                } else if (tag instanceof MoveToEx) {
                    MoveToEx mte = (MoveToEx)tag;
                    this.currentPosition = mte.getPoint();
                } else if (tag instanceof Pie) {
                    Pie arc = (Pie)tag;
                    double nx0 = arc.getStart().x / arc.getBounds().width;
                    double nx1 = arc.getEnd().x / arc.getBounds().width;
                    double alpha0 = Math.acos(nx0);
                    double alpha1 = Math.acos(nx1);
                    Arc2D.Double arc2d = new Arc2D.Double(arc.getStart().x, arc.getStart().y, arc.getBounds().width, arc.getBounds().height, alpha0, alpha1 - alpha0, 2);
                    g2.draw(arc2d);
                } else {
                    System.out.println("tag " + tag + " not supported");
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream(args[0]);
            EMFInputStream emf = new EMFInputStream(fis);
            JFrame frame = new JFrame("EMF " + args[0]);
            JScrollPane sp = new JScrollPane(new EMFDisplay(emf));
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)sp, "Center");
            frame.setDefaultCloseOperation(3);
            frame.setSize(550, 400);
            frame.setVisible(true);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

